<?php
header('Content-Type: application/json');
require __DIR__ . '/bt_api.php';
require __DIR__ . '/helper.php';

$servers_raw = include __DIR__ . '/servers.php';
$servers = getServersWithActualExpire($servers_raw);

$key = $_GET['key'] ?? '';
if (!$key) exit(json_encode(['error' => 'Server key missing']));
$server = null;
foreach ($servers as $srv) {
    if ($srv['key'] === $key) {
        $server = $srv;
        break;
    }
}
if (!$server) exit(json_encode(['error'=>'Server not found']));
$panel = $server['panel'];
$api_key = $server['key'];
// 获取系统信息
$sys = bt_api($panel, $api_key, '/system?action=GetSystemTotal');
$disk = bt_api($panel, $api_key, '/system?action=GetDiskInfo');
$net = bt_api($panel, $api_key, '/system?action=GetNetWork');
if (isset($sys['error'])) exit(json_encode(['error'=>$sys['error']]));
if (isset($disk['error'])) $disk = [];
if (isset($net['error'])) $net = [];
// CPU
$cpu = isset($sys['cpuRealUsed']) ? floatval($sys['cpuRealUsed']) : 0;
// 内存
$mem = 0;
if (isset($sys['memRealUsed']) && isset($sys['memTotal']) && floatval($sys['memTotal'])>0) {
    $mem = round(floatval($sys['memRealUsed']) / floatval($sys['memTotal']) * 100, 1);
}
// 网络
$net_up = floatval($net['up'] ?? 0);
$net_down = floatval($net['down'] ?? 0);
// 磁盘
$disk_list = [];
if (isset($disk[0]['path'])) {
    foreach ($disk as $d) {
        $size = $d['size'] ?? [];
        $used_percent = isset($size[3]) ? floatval(str_replace('%','',$size[3])) : 0;
        $disk_list[] = [
            'path'=>$d['path'],
            'used'=>$used_percent,
            'usedSize'=>$size[1] ?? '',
            'totalSize'=>$size[0] ?? ''
        ];
    }
}
// 到期天数
$expire_diff = null;
if (!empty($server['expire'])) {
    $expire_diff = (int)( (strtotime($server['expire']) - time()) / 86400 );
}
// 格式化到期时间 MM/DD
$expire_fmt = '';
if (!empty($server['expire'])) {
    $expire_fmt = date('m/d', strtotime($server['expire']));
}
// 输出
echo json_encode([
    'cpu'=>$cpu,
    'mem'=>$mem,
    'disk'=>$disk_list,
    'net_up'=>$net_up,
    'net_down'=>$net_down,
    'version'=>$sys['version'] ?? '',
    'expire_diff'=>$expire_diff,
    'expire_fmt'=>$expire_fmt
]);