<?php
function bt_api(string $panel, string $api_sk, string $uri, array $params = [], int $timeout = 10): array {
    $request_time = time();
    $request_token = md5($request_time . md5($api_sk));
    $params['request_time']  = $request_time;
    $params['request_token'] = $request_token;
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, rtrim($panel, '/') . $uri);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($params));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, $timeout);
    $cookie_file = __DIR__ . '/bt_cookie.txt';
    curl_setopt($ch, CURLOPT_COOKIEJAR, $cookie_file);
    curl_setopt($ch, CURLOPT_COOKIEFILE, $cookie_file);
    // 开发环境可用，生产环境建议开启验证
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
    $res = curl_exec($ch);
    $err = curl_error($ch);
    $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    if ($err !== '') return ['error' => "curl error: " . $err];
    if ($http_code != 200) return ['error'=>'HTTP code: '.$http_code];
    $json = json_decode($res, true);
    if ($json === null && json_last_error() !== JSON_ERROR_NONE) {
        return ['error' => 'json decode error: ' . json_last_error_msg(), 'raw' => $res];
    }
    return $json;
}